!!ARBvp1.0
# terrain bump__nodefines.vsh

TEMP r0, r1, r2, r5, r6, r7;

PARAM c[13] = {program.env[0..12]};
PARAM c0 = {0.3, 0.5, 2.0, 0.0};
PARAM c1 = {1.0, 1.0, 1.0, 1.0};
PARAM c21 = {0.0, 1.0, -1.0, 0.0};

ATTRIB v0 = vertex.position;
ATTRIB v1 = vertex.normal;
ATTRIB v2 = vertex.texcoord[0];

ALIAS oPos = result.position;
ALIAS oD1 = result.color.secondary;
ALIAS oT0 = result.texcoord[0];

# transform position
DP4 oPos.x, v0, c[4];
DP4 oPos.y, v0, c[5];
DP4 oPos.z, v0, c[6];
DP4 oPos.w, v0, c[7];

# Compute tangent from normal based on the regularity of the heightfield.
# -- just cross product with 1,0,0,0
MUL r7, v1.xzyw, c21;

# cross prod to generate binormal in model space -- "w"
MUL r0, v1.zxyw, r7.yzxw;
MAD r5, v1.yzxw, -r7.zxyw, -r0;

# transform the light vector by the resulting matrix to get the light dir in tan space (into r6)
DP3 r6.x, r5, c[2];
DP3 r6.y, r7, c[2];
DP3 r6.z, v1, c[2];
MOV r6.w, c21.x;

# multiply by a half then add half (to be scaled biased back inside pixel shader)
MAD oD1.xyz, r6, c0.y, c0.y;

# Copy texture coordinate to stages 0 (diffuse/bump/mask have same texcoords)
MOV oT0, v2;

END
